/*
noMeiryoUI (C) 2005,2012-2016 Tatsuhiko Shoji
The sources for noMeiryoUI are distributed under the MIT open source license
*/
#include <string.h>
#include <windows.h>

#include "TwrMenu.h"

/**
 * j[NX
 */

/**
 * RXgN^
 *
 * @param IuWFNgɌѕtEChẼnh
 */
TwrMenu::TwrMenu(HWND wnd)
{
	menuHandle = GetMenu(wnd);
}

/**
 * RXgN^
 *
 * @param IuWFNgɌѕtEChẼnh
 */
TwrMenu::TwrMenu(HMENU menu)
{
	menuHandle = menu;
}

/**
 * j[̃`FbNԂݒ肷B
 *
 * @param id j[ID
 * @param true:`FbN false:`FbNȂ
 */
void TwrMenu::CheckMenuItem(int id, bool checked)
{
	 MENUITEMINFO info;

	 memset(&info, 0, sizeof(MENUITEMINFO));
	 info.cbSize = sizeof(MENUITEMINFO);
	 info.fMask = MIIM_STATE;

	 GetMenuItemInfo(menuHandle, id, FALSE, &info);
	 if (checked) {
		 info.fState |= MFS_CHECKED;
	 } else {
		 if (info.fState & MFS_CHECKED) {
			info.fState ^= MFS_CHECKED;
		 }
	 }
	 SetMenuItemInfo(menuHandle, id, FALSE, &info);
}

/**
 * j[̃`FbNԂݒ肷B
 *
 * @param item j[ID
 * @return true:`FbN false:`FbNȂ
 */
bool TwrMenu::isChecked(int item)
{
	 MENUITEMINFO info;

	 memset(&info, 0, sizeof(MENUITEMINFO));
	 info.cbSize = sizeof(MENUITEMINFO);
	 info.fMask = MIIM_STATE;

	 GetMenuItemInfo(menuHandle, item, FALSE, &info);
	 if (info.fState & MFS_CHECKED) {
		 return true;
	 } else {
		 return false;
	 }
}

/**
 * j[̗LԂݒ肷B
 *
 * @param id j[ID
 * @param true:Lɂ false:LɂȂ
 */
void TwrMenu::setEnabled(int id, bool enabled)
{
	MENUITEMINFO info;

	memset(&info, 0, sizeof(MENUITEMINFO));
	info.cbSize = sizeof(MENUITEMINFO);
	info.fMask = MIIM_STATE;

	GetMenuItemInfo(menuHandle, id, FALSE, &info);
	if (enabled) {
		if (info.fState & MFS_ENABLED) {
			info.fState ^= MFS_ENABLED;
		}
	} else {
		info.fState |= MFS_DISABLED;
	}
	SetMenuItemInfo(menuHandle, id, FALSE, &info);
}

/**
 * j[̕ݒ肷B
 *
 * @param position j[̈ʒu/j[ڂID
 * @param message ݒ肷郁bZ[W
 * @param byPosition w@(TRUE:j[̈ʒu FALSE:j[ڂID)
 */
void TwrMenu::setText(int position, const TCHAR *message, BOOL byPosition)
{
	MENUITEMINFO info;

	info.cbSize = sizeof(MENUITEMINFO);
	info.fMask = MIIM_FTYPE | MIIM_STRING;
	info.fType = MFT_STRING;
	info.dwTypeData = (LPTSTR)message;
	SetMenuItemInfo(menuHandle, position, byPosition, &info);
}
